<?php
$services = ClassRegistry::init('Service')->find('all', []);
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// Load Composer's autoloader
require 'vendor/autoload.php';

// Instantiation and passing `true` enables exceptions
$mail = new PHPMailer(true);
?>

<?php foreach ($services as $i => $service) { ?>
	<section class="section-service<?= $i % 2 !== 0 ? '' : ' bg-image padding-bottom'?>" style="background-image: url(<?= $i % 2 == 0 ? $service['Image']['file'] : '' ?>);" id="<?= str_replace(' ', '', $service['Service']['title'])?>">
		<div class="inner">
			<?php if($i % 2 !== 0 ) { ?>
				<div class="row">
					<div class="column __7 lt__3 st__6" data-mh="group-1">
						<div class="section-image">
							<img src="<?= $service['Image']['file'] ?>" />
						</div>
					</div>
					<div class="column __5 lt__3 st__6" data-mh="group-1">
						<div class="vertical-align">
							<div class="section-heading heading-icon">
								<div><img src="<?= $service['Icon']['file'] ?>" /></div>
								<h2><?= $service['Service']['title'] ?></h2>
							</div>
			<?php } else { ?>
				<div class="section-heading heading-icon">
					<div><img src="<?= $service['Icon']['file'] ?>" /></div>
					<h2><?= $service['Service']['title'] ?></h2>
				</div>
				<div class="section-body">
					<div class="row">
						<div class="column __8 lt__5 st__6">
			<?php } ?>
							<div class="section-body">
								<div class="rich-text">
									<?= $service['Service']['description'] ?>
								</div>
							</div>
			<?php if($i % 2 == 0 ) { ?>
						</div>
					</div>
				</div>
						<?php } ?>
							<div class="section-footer">
								<?php if($service['Service']['additional_block']) { ?>
									<?php if(empty($service['AdditionalBlockFile' . ucfirst($locale)]['file'])) { ?>
										<div class="license-block">
											<?php if(!empty($service['AdditionalBlockImage']['file'])) { ?>
												<div><img src="<?= $service['AdditionalBlockImage']['file'] ?>" /></div>
											<?php } ?>
											<div>
												<p><?= $service['Service']['additional_block_title'] ?></p>
												<h3><?= $service['Service']['additional_block_text'] ?></h3>
											</div>
										</div>
									<?php } else { ?>
										<a href="<?= $service['AdditionalBlockFile' . ucfirst($locale)]['file'] ?>" class="license-block" target="_blank">
                                            <?php if(!empty($service['AdditionalBlockImage']['file'])) { ?>
												<div><img src="<?= $service['AdditionalBlockImage']['file'] ?>" /></div>
                                            <?php } ?>											<div>
												<p><?= $service['Service']['additional_block_title'] ?></p>
												<h3><?= $service['Service']['additional_block_text'] ?></h3>
											</div>
										</a>
                                    <?php } ?>
                                <?php } ?>
								<div><a href="javascript:void(0)" class="button btn-secondary btn-ghost requestPopup_open" data-popup-id="<?= $service['Service']['id'] ?>"><span><?php echo __('zahtev za ponudom') ?></span></a></div>
							</div>
			<?php if($i % 2 === 0 ) { ?>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
	</section>
<?php } ?>

<div id="requestPopup" class="popup">
	<div class="popup-heading">
		<h2>Zahtev za ponudom</h2>
		<a href="javascript:void(0)" class="close-popup requestPopup_close"><img src="/img/ic-close.png" /></a>
	</div>

	<form method="post" action="/api/v1/request" id="RequestForm">
		<div class="popup-body">
			<div class="form">
				<div class="row">
					<div class="column __4">
						<label class="inline">Naziv društva:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" name="data[name]" />
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Matični broj:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" name="data[registration_number]" />
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Kontakt osoba:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" name="data[contact_person]" />
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Kontakt telefon:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" name="data[phone]" />
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Email adresa:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" name="data[email]" />
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Izaberite uslugu:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<select name="data[cms_service_id]" class="input" data-service-id>
								<?php foreach ($services as $service) { ?>
									<option value="<?= $service['Service']['id'] ?>"><?= $service['Service']['title'] ?></option>
								<?php } ?>
							</select>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="popup-footer">
			<div class="submit">
				<button class="button btn-primary" type="submit"><span>Pošaljite zahtev</span></button>
				<div class="form-message"></div>
			</div>
		</div>
	</form>
</div>
	<!-- POPUP -->

<script type="text/javascript">
	methodStack.push(function () {

		if ($(window).width() <= 1024 && $(window).width() > 768) {
			$('.vertical-align').css({
				'position' : 'absolute',
				'top' : '50%',
				'margin-top' : -$('.vertical-align').outerHeight()/2
			});
		}

		$('[data-popup-id]').click(function () {
			$('[data-service-id]').val($(this).data('popup-id'))
		});

		$('.popup').popup({
			outline: true,
			focusdelay: 400,
			color: '#0b0c13',
			opacity: 0.7
		});

		$('.logos-block.slider').slick({
			slidesToShow: 5,
			slidesToScroll: 5,
			infinite: false,
			dots: true,
			prevArrow:"<div class='slick-prev'>",
			nextArrow:"<div class='slick-next'>",
			customPaging: function(slider, i) {
				return $('<div data-role="none" role="button" tabindex="0" />').text(i + 1);
			}
		});

		$('#RequestForm').intlxform();
	});
</script>
